<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */
 
  /*===================================================
    ProcessRating()
  ===================================================*/

  function ProcessRating() {

    // vars global configuration
    global $theme_path, $top_rated_limit;

    // vars url & form
    global $id, $rating;

    // vars messages
    global $msg;

    // vars template
    global $error_msg, $title;

    $links_obj = new clsLink;
    $links_obj->query            = "select * from idx_link where link_id = '$id'";
    $links_obj->table_name       = "idx_link";
    $links_obj->votes_table_name = "idx_votes";
    $links_obj->top_rated_limit  = $top_rated_limit;
    $rating_result               = $links_obj->RateLink($id, $rating);

    if ($rating < 1 || $rating > 5) {
      $rating_result = 2; // error
    }


    // success
    if ($rating_result == 0) {
      $title = $links_obj->GetLinkTitle($id);
      DisplayTemplate($theme_path . "rating_ok.html", "\$title");
    }
    
    // user already rated
    elseif ($rating_result == 1) {
      $error_msg = $msg["10171"];
      DisplayTemplate($theme_path . "rating_error.html", "\$error_msg");
    }

    // rated fail
    else {
      $error_msg = $msg["10172"];
      DisplayTemplate($theme_path . "rating_error.html", "\$error_msg");
    }
  }


  /*===================================================
    main
  ===================================================*/

  include "application.php";

  RunPreFilter(__FILE__);

  $query     = "select suspended from idx_link where link_id = '$id'";
  $result    = $dbConn->Execute($query);
  $suspended = $result->Fields("suspended");

  if ($suspended) {
    DisplayTemplate($theme_path . "suspended.html");
    RunPostFilter(__FILE__);
  }

  ProcessRating();

  RunPostFilter(__FILE__);

?>